#ifndef FILE_H_INCLUDED
#define FILE_H_INCLUDED
#include "gmp.h"

#define KAZ_KEM_SP_J						122
#define KAZ_KEM_SP_SL						256

#define KAZ_KEM_SP_N						"29421818394147345935036136135391375994024126405325576672227398037493559452008116283594709069097880319117946343281357631447556041903884586208161678710597469727999746179863045388559147407457068275815914914983896392757878683919189075898269550939868181179868469970964809582599153788719655"
#define KAZ_KEM_SP_LN						942 // in binary (118 bytes)

#define KAZ_KEM_SP_g1						"7"
#define KAZ_KEM_SP_g2						"23"
#define KAZ_KEM_SP_g3						"65537"

#define KAZ_KEM_SP_Og1N						"99154693887499828557116081873795155652147461554242228686027806044656980768000"
#define KAZ_KEM_SP_LOg1N					256 // in binary (33 bytes)
#define KAZ_KEM_SP_Og2N						"148732040831249742835674122810692733478221192331363343029041709066985471152000"
#define KAZ_KEM_SP_LOg2N					257 // in binary (33 bytes)
#define KAZ_KEM_SP_Og3N						"49577346943749914278558040936897577826073730777121114343013903022328490384000"
#define KAZ_KEM_SP_LOg3N					255 // in binary (33 bytes)

#define KAZ_KEM_PUBLICKEY_BYTES				118 // in bytes for each A1, A2, A3
#define KAZ_KEM_PRIVATEKEY_BYTES			33 // in bytes for each a1, a2, a3

#define KAZ_KEM_EPHERMERAL_PUBLIC_BYTES		118 // in bytes for each B1, B2, B3
#define KAZ_KEM_EPHERMERAL_PRIVATE_BYTES	33 // in bytes for each b1, b2, b3

#define KAZ_KEM_GENERAL_BYTES				118 // in bytes for message, encapsulate message, decapsulate message

extern void KAZ_KEM_RANDOM(mpz_t lb, mpz_t ub, mpz_t out);

extern int KAZ_KEM_KEYGEN(unsigned char *kaz_kem_public_key,
                           unsigned char *kaz_kem_private_key);

extern int KAZ_KEM_ENCAPSULATION(unsigned char *encapsulation, unsigned long long *encaplen,
                                 const unsigned char *m, unsigned long long mlen,
                                 const unsigned char *kaz_kem_public_key);

extern int KAZ_KEM_DECAPSULATION(unsigned char *decapsulation, unsigned long long *decaplen,
                                 const unsigned char *encapsulation, unsigned long long encaplen,
                                 const unsigned char *kaz_kem_private_key);

#endif // FILE_H_INCLUDED
